unit MovieData1;

{
  A MIDAS server for movie-watcher data - data module.
  Requires 'movie-watcher' alias to be set up in BDE.

  Copyright  Keith Wood (kbwood@iprimus.com.au)
  Written 28 November, 2000.
}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, MovieServer_TLB, StdVcl, Provider, Db, DBTables;

type
  TMovieData = class(TRemoteDataModule, IMovieData)
    dspMovies: TDataSetProvider;
    sesMovies: TSession;
    qryMovies: TQuery;
    dsrMovies: TDataSource;
    qryStars: TQuery;
    procedure qryMoviesAfterOpen(DataSet: TDataSet);
    procedure RemoteDataModuleCreate(Sender: TObject);
    procedure RemoteDataModuleDestroy(Sender: TObject);
  private
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
  public
  end;

implementation

{$R *.DFM}

uses
  MovieServer1;

class procedure TMovieData.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

{ Count the query }
procedure TMovieData.qryMoviesAfterOpen(DataSet: TDataSet);
begin
  frmMovieServer.AddQuery;
end;

{ Count the client }
procedure TMovieData.RemoteDataModuleCreate(Sender: TObject);
begin
  frmMovieServer.AddClient(1);
end;

{ Deduct the client }
procedure TMovieData.RemoteDataModuleDestroy(Sender: TObject);
begin
  frmMovieServer.AddClient(-1);
end;

initialization
  TComponentFactory.Create(ComServer, TMovieData,
    Class_MovieData, ciMultiInstance, tmApartment);
end.
